/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.service.plugin;

import dev.e4studio.e4core.api.E4Core;
import dev.e4studio.e4core.api.lifecycle.E4ManagedPlugin;
import dev.e4studio.e4core.api.plugin.E4PluginService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class E4PluginManager
implements E4PluginService {
    private final JavaPlugin owner;
    private E4Core core;

    public E4PluginManager(JavaPlugin owner) {
        this.owner = owner;
    }

    public void bindCore(E4Core core) {
        this.core = core;
    }

    @Override
    public List<String> getManagedPluginNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Plugin plugin : this.getManagedPlugins()) {
            names.add(plugin.getName());
        }
        return names;
    }

    @Override
    public E4PluginService.ReloadResult reloadManagedPlugins() {
        PluginManager pluginManager = this.owner.getServer().getPluginManager();
        List<Plugin> managed = this.getManagedPlugins();
        ArrayList<String> failed = new ArrayList<String>();
        int reloaded = 0;
        for (Plugin plugin : managed) {
            if (!plugin.isEnabled()) continue;
            try {
                E4ManagedPlugin reloadAware;
                if (plugin instanceof E4ManagedPlugin) {
                    reloadAware = (E4ManagedPlugin)plugin;
                    if (this.core != null) {
                        reloadAware.beforeE4CoreReload(this.core);
                    }
                }
                pluginManager.disablePlugin(plugin);
                pluginManager.enablePlugin(plugin);
                if (plugin instanceof E4ManagedPlugin) {
                    reloadAware = (E4ManagedPlugin)plugin;
                    if (this.core != null) {
                        reloadAware.afterE4CoreReload(this.core);
                    }
                }
                ++reloaded;
            }
            catch (Exception exception) {
                this.owner.getLogger().warning("[e4Core] Could not reload plugin '" + plugin.getName() + "': " + exception.getMessage());
                failed.add(plugin.getName());
            }
        }
        return new E4PluginService.ReloadResult(managed.size(), reloaded, failed.size(), failed);
    }

    public List<Plugin> getManagedPlugins() {
        return Arrays.stream(this.owner.getServer().getPluginManager().getPlugins()).filter(plugin -> !plugin.equals((Object)this.owner)).filter(this::isManagedPlugin).toList();
    }

    private boolean isManagedPlugin(Plugin plugin) {
        List depend = plugin.getPluginMeta().getPluginDependencies();
        List softDepend = plugin.getPluginMeta().getPluginSoftDependencies();
        return this.hasCoreDependency(depend) || this.hasCoreDependency(softDepend);
    }

    private boolean hasCoreDependency(List<String> dependencies) {
        return dependencies.stream().anyMatch(dependency -> dependency.equalsIgnoreCase("e4Core"));
    }
}

