/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.service.install;

import dev.e4studio.e4core.api.analytics.AnalyticsService;
import dev.e4studio.e4core.service.catalog.CatalogPluginEntry;
import dev.e4studio.e4core.service.catalog.PluginCatalogService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginInstallerService {
    private final JavaPlugin plugin;
    private final PluginCatalogService catalogService;
    private final AnalyticsService analyticsService;

    public PluginInstallerService(JavaPlugin plugin, PluginCatalogService catalogService, AnalyticsService analyticsService) {
        this.plugin = plugin;
        this.catalogService = catalogService;
        this.analyticsService = analyticsService;
    }

    public void installPluginAsync(String key, CommandSender sender) {
        Optional<CatalogPluginEntry> optionalEntry = this.catalogService.find(key);
        if (optionalEntry.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)("Plugin no encontrado en cat\u00e1logo: " + key), (TextColor)NamedTextColor.RED));
            sender.sendMessage((Component)Component.text((String)"Usa /e4core list para ver opciones.", (TextColor)NamedTextColor.YELLOW));
            return;
        }
        CatalogPluginEntry entry = optionalEntry.get();
        sender.sendMessage((Component)Component.text((String)("Descargando " + entry.pluginName() + "..."), (TextColor)NamedTextColor.YELLOW));
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Path pluginsDir = this.plugin.getDataFolder().toPath().getParent();
                if (pluginsDir == null) {
                    throw new IOException("No se pudo determinar la carpeta plugins del servidor.");
                }
                Path downloadsDir = this.plugin.getDataFolder().toPath().resolve("downloads");
                Files.createDirectories(downloadsDir, new FileAttribute[0]);
                Path targetFile = pluginsDir.resolve(entry.fileName());
                Path tempFile = downloadsDir.resolve(entry.fileName() + ".part");
                this.download(entry, tempFile);
                Files.move(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                this.analyticsService.trackEvent("e4Core", "plugin_download_success");
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.activatePluginIfPossible(entry, targetFile, sender));
            }
            catch (Exception exception) {
                this.analyticsService.trackEvent("e4Core", "plugin_download_fail");
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage((Component)Component.text((String)("Error al descargar plugin: " + exception.getMessage()), (TextColor)NamedTextColor.RED)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(CatalogPluginEntry entry, Path output) throws IOException {
        int connectTimeout = this.plugin.getConfig().getInt("downloads.connect-timeout-ms", 10000);
        int readTimeout = this.plugin.getConfig().getInt("downloads.read-timeout-ms", 20000);
        HttpURLConnection connection = (HttpURLConnection)URI.create(entry.url()).toURL().openConnection();
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        connection.setRequestProperty("User-Agent", "e4Core-Installer/1.0");
        int responseCode = connection.getResponseCode();
        if (responseCode >= 400) {
            throw new IOException("HTTP " + responseCode + " al descargar " + entry.key());
        }
        try (InputStream stream = connection.getInputStream();){
            Files.copy(stream, output, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            connection.disconnect();
        }
    }

    private void activatePluginIfPossible(CatalogPluginEntry entry, Path file, CommandSender sender) {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Plugin existing = pluginManager.getPlugin(entry.pluginName());
        if (existing != null) {
            sender.sendMessage((Component)Component.text((String)("Plugin descargado en /plugins, pero '" + entry.pluginName() + "' ya estaba cargado. Reinicia el servidor para aplicar la nueva versi\u00f3n."), (TextColor)NamedTextColor.YELLOW));
            return;
        }
        boolean autoEnable = this.plugin.getConfig().getBoolean("downloads.auto-enable", true);
        if (!autoEnable) {
            sender.sendMessage((Component)Component.text((String)"Plugin descargado correctamente en /plugins. Act\u00edvalo manualmente o reinicia el servidor.", (TextColor)NamedTextColor.GREEN));
            return;
        }
        try {
            Plugin loaded = pluginManager.loadPlugin(file.toFile());
            pluginManager.enablePlugin(loaded);
            sender.sendMessage((Component)Component.text((String)("Plugin " + loaded.getName() + " instalado y activado correctamente."), (TextColor)NamedTextColor.GREEN));
            this.analyticsService.trackEvent("e4Core", "plugin_install_success");
        }
        catch (InvalidDescriptionException | InvalidPluginException | UnknownDependencyException exception) {
            sender.sendMessage((Component)Component.text((String)("Plugin descargado, pero no se pudo activar autom\u00e1ticamente: " + exception.getMessage()), (TextColor)NamedTextColor.YELLOW));
            this.analyticsService.trackEvent("e4Core", "plugin_install_fail");
        }
    }
}

