/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.service.database;

import dev.e4studio.e4core.api.database.DatabaseService;
import dev.e4studio.e4core.api.database.DatabaseType;
import dev.e4studio.e4core.libs.hikari.HikariConfig;
import dev.e4studio.e4core.libs.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager
implements DatabaseService {
    private final JavaPlugin plugin;
    private HikariDataSource dataSource;
    private DatabaseType type = DatabaseType.SQLITE;
    private boolean enabled;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean initialize() {
        this.shutdown();
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("database.enabled", true);
        if (!this.enabled) {
            this.plugin.getLogger().warning("[e4Core] Database is disabled in config.");
            return false;
        }
        this.type = DatabaseType.from(config.getString("database.type", "SQLITE"));
        try {
            HikariConfig hikariConfig = this.buildHikariConfig(config);
            this.dataSource = new HikariDataSource(hikariConfig);
            this.createCoreTables();
            this.plugin.getLogger().info("[e4Core] Database connected using " + String.valueOf((Object)this.type) + ".");
            return true;
        }
        catch (Exception exception) {
            this.plugin.getLogger().severe("[e4Core] Could not initialize database: " + exception.getMessage());
            this.shutdown();
            return false;
        }
    }

    private HikariConfig buildHikariConfig(FileConfiguration config) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName("e4CorePool");
        hikariConfig.setMaximumPoolSize(config.getInt("database.pool.maximum-pool-size", 10));
        hikariConfig.setMinimumIdle(config.getInt("database.pool.minimum-idle", 2));
        hikariConfig.setConnectionTimeout(config.getLong("database.pool.connection-timeout-ms", 10000L));
        hikariConfig.setIdleTimeout(config.getLong("database.pool.idle-timeout-ms", 600000L));
        hikariConfig.setMaxLifetime(config.getLong("database.pool.max-lifetime-ms", 1800000L));
        if (this.type == DatabaseType.SQLITE) {
            File storageDir = new File(this.plugin.getDataFolder(), "storage");
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                this.plugin.getLogger().warning("[e4Core] Could not create storage directory for SQLite.");
            }
            File databaseFile = new File(storageDir, "e4core.db");
            hikariConfig.setJdbcUrl("jdbc:sqlite:" + databaseFile.getPath());
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
        } else {
            String host = config.getString("database.mysql.host", "127.0.0.1");
            int port = config.getInt("database.mysql.port", 3306);
            String database = config.getString("database.mysql.database", "minecraft");
            String username = config.getString("database.mysql.username", "root");
            String password = config.getString("database.mysql.password", "");
            boolean ssl = config.getBoolean("database.mysql.use-ssl", false);
            String additional = config.getString("database.mysql.additional-parameters", "");
            StringBuilder jdbcUrl = new StringBuilder("jdbc:mysql://").append(host).append(":").append(port).append("/").append(database).append("?useSSL=").append(ssl);
            if (additional != null && !additional.isBlank()) {
                jdbcUrl.append("&").append(additional);
            }
            hikariConfig.setJdbcUrl(jdbcUrl.toString());
            hikariConfig.setUsername(username);
            hikariConfig.setPassword(password);
            hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
        }
        return hikariConfig;
    }

    private void createCoreTables() throws SQLException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS e4_analytics_events (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    source_plugin VARCHAR(100) NOT NULL,\n    event_key VARCHAR(100) NOT NULL,\n    metadata TEXT,\n    created_at BIGINT NOT NULL\n)\n");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS e4_plugin_registry (\n    plugin_name VARCHAR(100) PRIMARY KEY,\n    plugin_version VARCHAR(30) NOT NULL,\n    last_seen BIGINT NOT NULL,\n    enabled BOOLEAN NOT NULL\n)\n");
        }
    }

    public void registerDependentPlugin(Plugin targetPlugin, boolean pluginEnabled) {
        if (!this.isEnabled()) {
            return;
        }
        String sql = "INSERT INTO e4_plugin_registry (plugin_name, plugin_version, last_seen, enabled)\nVALUES (?, ?, ?, ?)\nON CONFLICT(plugin_name) DO UPDATE SET\n    plugin_version=excluded.plugin_version,\n    last_seen=excluded.last_seen,\n    enabled=excluded.enabled\n";
        this.executeAsync(sql, statement -> {
            statement.setString(1, targetPlugin.getName());
            statement.setString(2, targetPlugin.getPluginMeta().getVersion());
            statement.setLong(3, Instant.now().toEpochMilli());
            statement.setBoolean(4, pluginEnabled);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.dataSource != null;
    }

    @Override
    public DatabaseType getType() {
        return this.type;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Database datasource is not initialized.");
        }
        return this.dataSource.getConnection();
    }

    @Override
    public int execute(String sql, DatabaseService.SqlConsumer<PreparedStatement> binder) throws SQLException {
        try (Connection connection = this.getConnection();){
            int n;
            block13: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    if (binder != null) {
                        binder.accept(statement);
                    }
                    n = statement.executeUpdate();
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
    }

    @Override
    public void executeAsync(String sql, DatabaseService.SqlConsumer<PreparedStatement> binder) {
        if (!this.isEnabled()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.execute(sql, binder);
            }
            catch (SQLException exception) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getLogger().warning("[e4Core] Async SQL execution failed: " + exception.getMessage()));
            }
        });
    }

    public void shutdown() {
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }
}

