/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.service.catalog;

import dev.e4studio.e4core.service.catalog.CatalogPluginEntry;
import dev.e4studio.e4core.service.catalog.InternalPluginCatalog;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginCatalogService {
    private final JavaPlugin plugin;
    private final Map<String, CatalogPluginEntry> entries = new LinkedHashMap<String, CatalogPluginEntry>();

    public PluginCatalogService(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        this.entries.clear();
        for (CatalogPluginEntry entry : InternalPluginCatalog.entries()) {
            if (entry == null) continue;
            String key = entry.key();
            String pluginName = entry.pluginName();
            String fileName = entry.fileName();
            String url = entry.url();
            String description = entry.description();
            if (key == null || key.isBlank() || pluginName == null || pluginName.isBlank() || fileName == null || fileName.isBlank()) {
                this.plugin.getLogger().warning("[e4Core] Invalid internal catalog entry detected and ignored.");
                continue;
            }
            if (url == null || url.isBlank()) {
                this.plugin.getLogger().warning("[e4Core] Catalog entry '" + key + "' has empty URL and will be ignored.");
                continue;
            }
            String normalizedKey = key.toLowerCase(Locale.ROOT);
            if (this.entries.containsKey(normalizedKey)) {
                this.plugin.getLogger().warning("[e4Core] Duplicate internal catalog key '" + key + "'. Keeping first value.");
                continue;
            }
            this.entries.put(normalizedKey, new CatalogPluginEntry(key, pluginName, fileName, url, description));
        }
        this.plugin.getLogger().info("[e4Core] Loaded " + this.entries.size() + " catalog plugin entries.");
    }

    public Optional<CatalogPluginEntry> find(String key) {
        if (key == null || key.isBlank()) {
            return Optional.empty();
        }
        CatalogPluginEntry byKey = this.entries.get(key.toLowerCase(Locale.ROOT));
        if (byKey != null) {
            return Optional.of(byKey);
        }
        String normalizedInput = key.trim();
        for (CatalogPluginEntry entry : this.entries.values()) {
            if (!entry.pluginName().equalsIgnoreCase(normalizedInput)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public Collection<CatalogPluginEntry> getAll() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public boolean hasPluginName(String pluginName) {
        if (pluginName == null || pluginName.isBlank()) {
            return false;
        }
        for (CatalogPluginEntry entry : this.entries.values()) {
            if (!entry.pluginName().equalsIgnoreCase(pluginName.trim())) continue;
            return true;
        }
        return false;
    }
}

