/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.service.analytics;

import dev.e4studio.e4core.api.analytics.AnalyticsService;
import dev.e4studio.e4core.service.database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class AnalyticsManager
implements AnalyticsService {
    private final JavaPlugin plugin;
    private final DatabaseManager databaseManager;
    private final ConcurrentLinkedQueue<AnalyticsEvent> queue = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<String, AtomicLong> counters = new ConcurrentHashMap();
    private boolean enabled;
    private boolean storeInDatabase;
    private long retentionDays;
    private BukkitTask flushTask;
    private long flushes;

    public AnalyticsManager(JavaPlugin plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
    }

    public void initialize() {
        this.shutdown();
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("analytics.enabled", true);
        this.storeInDatabase = config.getBoolean("analytics.store-in-database", true);
        this.retentionDays = config.getLong("analytics.retention-days", 30L);
        if (!this.enabled) {
            this.plugin.getLogger().warning("[e4Core] Analytics are disabled in config.");
            return;
        }
        long flushIntervalSeconds = Math.max(5L, config.getLong("analytics.flush-interval-seconds", 60L));
        long periodTicks = flushIntervalSeconds * 20L;
        this.flushTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::flush, periodTicks, periodTicks);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void trackEvent(String sourcePlugin, String eventKey) {
        this.trackEvent(sourcePlugin, eventKey, Collections.emptyMap());
    }

    @Override
    public void trackEvent(String sourcePlugin, String eventKey, Map<String, String> metadata) {
        if (!this.enabled) {
            return;
        }
        String source = sourcePlugin == null || sourcePlugin.isBlank() ? "unknown" : sourcePlugin;
        String key = eventKey == null || eventKey.isBlank() ? "unspecified" : eventKey;
        this.queue.add(new AnalyticsEvent(source, key, this.serializeMetadata(metadata), Instant.now().toEpochMilli()));
        this.counters.computeIfAbsent(source + ":" + key, ignored -> new AtomicLong(0L)).incrementAndGet();
    }

    @Override
    public Map<String, Long> getLocalCounters() {
        ConcurrentHashMap<String, Long> snapshot = new ConcurrentHashMap<String, Long>();
        this.counters.forEach((key, value) -> snapshot.put((String)key, value.get()));
        return snapshot;
    }

    public void flush() {
        if (!this.enabled) {
            return;
        }
        if (!this.storeInDatabase || !this.databaseManager.isEnabled()) {
            this.drainQueue();
            return;
        }
        if (this.queue.isEmpty()) {
            return;
        }
        try (Connection connection = this.databaseManager.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO e4_analytics_events (source_plugin, event_key, metadata, created_at)\nVALUES (?, ?, ?, ?)\n");){
            AnalyticsEvent event;
            while ((event = this.queue.poll()) != null) {
                statement.setString(1, event.sourcePlugin());
                statement.setString(2, event.eventKey());
                statement.setString(3, event.metadata());
                statement.setLong(4, event.createdAt());
                statement.addBatch();
            }
            statement.executeBatch();
            ++this.flushes;
            if (this.flushes % 20L == 0L) {
                this.cleanupRetention();
            }
        }
        catch (SQLException exception) {
            this.plugin.getLogger().warning("[e4Core] Analytics flush failed: " + exception.getMessage());
        }
    }

    private void cleanupRetention() {
        if (this.retentionDays <= 0L || !this.databaseManager.isEnabled()) {
            return;
        }
        long threshold = Instant.now().minusSeconds(this.retentionDays * 24L * 3600L).toEpochMilli();
        this.databaseManager.executeAsync("DELETE FROM e4_analytics_events WHERE created_at < ?", statement -> statement.setLong(1, threshold));
    }

    private void drainQueue() {
        while (this.queue.poll() != null) {
        }
    }

    private String serializeMetadata(Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(";");
        metadata.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    public void shutdown() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
            this.flushTask = null;
        }
        this.flush();
    }

    private record AnalyticsEvent(String sourcePlugin, String eventKey, String metadata, long createdAt) {
    }
}

