/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.listener;

import dev.e4studio.e4core.api.analytics.AnalyticsService;
import dev.e4studio.e4core.service.database.DatabaseManager;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class PluginLifecycleListener
implements Listener {
    private final Plugin owner;
    private final DatabaseManager databaseManager;
    private final AnalyticsService analyticsService;

    public PluginLifecycleListener(Plugin owner, DatabaseManager databaseManager, AnalyticsService analyticsService) {
        this.owner = owner;
        this.databaseManager = databaseManager;
        this.analyticsService = analyticsService;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginEnable(PluginEnableEvent event) {
        Plugin plugin = event.getPlugin();
        if (plugin.equals((Object)this.owner) || !this.declaresE4CoreDependency(plugin)) {
            return;
        }
        this.analyticsService.trackEvent(plugin.getName(), "plugin_enabled");
        this.databaseManager.registerDependentPlugin(plugin, true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent event) {
        Plugin plugin = event.getPlugin();
        if (plugin.equals((Object)this.owner) || !this.declaresE4CoreDependency(plugin)) {
            return;
        }
        this.analyticsService.trackEvent(plugin.getName(), "plugin_disabled");
        this.databaseManager.registerDependentPlugin(plugin, false);
    }

    private boolean declaresE4CoreDependency(Plugin plugin) {
        List depend = plugin.getPluginMeta().getPluginDependencies();
        List softDepend = plugin.getPluginMeta().getPluginSoftDependencies();
        return this.containsCore(depend) || this.containsCore(softDepend);
    }

    private boolean containsCore(List<String> dependencies) {
        return dependencies.stream().anyMatch(dependency -> dependency.equalsIgnoreCase("e4Core"));
    }
}

