/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core.command;

import dev.e4studio.e4core.E4CorePlugin;
import dev.e4studio.e4core.api.plugin.E4PluginService;
import dev.e4studio.e4core.service.catalog.CatalogPluginEntry;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class E4CoreCommand
implements CommandExecutor {
    private final E4CorePlugin plugin;

    public E4CoreCommand(E4CorePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("e4core.admin")) {
            sender.sendMessage((Component)Component.text((String)"No tienes permiso para usar este comando.", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("status")) {
            sender.sendMessage((Component)Component.text((String)"[e4Core] Estado:", (TextColor)NamedTextColor.GOLD));
            sender.sendMessage((Component)Component.text((String)("- Versi\u00f3n: " + this.plugin.getPluginMeta().getVersion()), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)("- Database: " + (String)(this.plugin.getDatabaseManager().isEnabled() ? "ON (" + String.valueOf((Object)this.plugin.getDatabaseManager().getType()) + ")" : "OFF")), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)("- Analytics: " + (this.plugin.getAnalyticsManager().isEnabled() ? "ON" : "OFF")), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)("- Plugins e4 detectados: " + this.plugin.getPluginManagerService().getManagedPluginNames().size()), (TextColor)NamedTextColor.GRAY));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            sender.sendMessage((Component)Component.text((String)"Recargando runtime de e4Core y plugins e4Studio...", (TextColor)NamedTextColor.YELLOW));
            boolean runtimeOk = this.plugin.reloadRuntime();
            if (!runtimeOk) {
                sender.sendMessage((Component)Component.text((String)"Runtime de e4Core fall\u00f3 al recargar. Revisa consola.", (TextColor)NamedTextColor.RED));
                return true;
            }
            E4PluginService.ReloadResult result = this.plugin.reloadManagedPlugins();
            sender.sendMessage((Component)Component.text((String)("Recarga completada: total=" + result.total() + ", recargados=" + result.reloaded() + ", fallidos=" + result.failed()), (TextColor)(result.failed() == 0 ? NamedTextColor.GREEN : NamedTextColor.YELLOW)));
            if (!result.failedPlugins().isEmpty()) {
                sender.sendMessage((Component)Component.text((String)("Fallidos: " + String.join((CharSequence)", ", result.failedPlugins())), (TextColor)NamedTextColor.RED));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            String available = this.plugin.getCatalogService().getAll().stream().map(CatalogPluginEntry::key).collect(Collectors.joining(", "));
            sender.sendMessage((Component)Component.text((String)(available.isBlank() ? "Cat\u00e1logo vac\u00edo." : "Cat\u00e1logo: " + available), (TextColor)NamedTextColor.AQUA));
            return true;
        }
        if (args[0].equalsIgnoreCase("download")) {
            if (args.length < 2) {
                sender.sendMessage((Component)Component.text((String)("Uso: /" + label + " download <pluginName|id>"), (TextColor)NamedTextColor.RED));
                return true;
            }
            if (!this.plugin.getConfig().getBoolean("downloads.enabled", true)) {
                sender.sendMessage((Component)Component.text((String)"Las descargas est\u00e1n deshabilitadas en config.yml", (TextColor)NamedTextColor.RED));
                return true;
            }
            this.plugin.getInstallerService().installPluginAsync(args[1], sender);
            return true;
        }
        sender.sendMessage((Component)Component.text((String)("Uso: /" + label + " [status|reload|list|download <pluginName|id>]"), (TextColor)NamedTextColor.RED));
        return true;
    }
}

