/*
 * Decompiled with CFR 0.152.
 */
package dev.e4studio.e4core;

import dev.e4studio.e4core.api.E4Core;
import dev.e4studio.e4core.api.E4CoreProvider;
import dev.e4studio.e4core.api.plugin.E4PluginService;
import dev.e4studio.e4core.command.E4CoreCommand;
import dev.e4studio.e4core.command.E4CoreCommandCompleter;
import dev.e4studio.e4core.listener.PluginLifecycleListener;
import dev.e4studio.e4core.service.E4CoreImpl;
import dev.e4studio.e4core.service.analytics.AnalyticsManager;
import dev.e4studio.e4core.service.catalog.PluginCatalogService;
import dev.e4studio.e4core.service.database.DatabaseManager;
import dev.e4studio.e4core.service.install.PluginInstallerService;
import dev.e4studio.e4core.service.plugin.E4PluginManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class E4CorePlugin
extends JavaPlugin {
    private DatabaseManager databaseManager;
    private AnalyticsManager analyticsManager;
    private PluginCatalogService catalogService;
    private PluginInstallerService installerService;
    private E4PluginManager pluginManagerService;
    private E4Core coreApi;

    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.initializeRuntime()) {
            this.getLogger().severe("[e4Core] Runtime could not be initialized, disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerCommands();
        this.registerListeners();
        this.analyticsManager.trackEvent("e4Core", "core_enabled");
        this.getLogger().info("[e4Core] Enabled successfully.");
    }

    public void onDisable() {
        if (this.analyticsManager != null) {
            this.analyticsManager.trackEvent("e4Core", "core_disabled");
            this.analyticsManager.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.shutdown();
        }
        E4CoreProvider.clear();
    }

    public boolean reloadRuntime() {
        this.reloadConfig();
        if (this.analyticsManager != null) {
            this.analyticsManager.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.shutdown();
        }
        return this.initializeRuntime();
    }

    public E4PluginService.ReloadResult reloadManagedPlugins() {
        return this.pluginManagerService.reloadManagedPlugins();
    }

    private boolean initializeRuntime() {
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        this.analyticsManager = new AnalyticsManager(this, this.databaseManager);
        this.analyticsManager.initialize();
        this.catalogService = new PluginCatalogService(this);
        this.catalogService.initialize();
        this.pluginManagerService = new E4PluginManager(this);
        this.coreApi = new E4CoreImpl(this, this.databaseManager, this.analyticsManager, this.pluginManagerService);
        this.pluginManagerService.bindCore(this.coreApi);
        this.installerService = new PluginInstallerService(this, this.catalogService, this.analyticsManager);
        this.validateManagedPluginsInCatalog();
        E4CoreProvider.setInstance(this.coreApi);
        return true;
    }

    private void validateManagedPluginsInCatalog() {
        for (Plugin managedPlugin : this.pluginManagerService.getManagedPlugins()) {
            if (this.catalogService.hasPluginName(managedPlugin.getName())) continue;
            this.getLogger().warning("[e4Core] Plugin '" + managedPlugin.getName() + "' depende de e4Core pero no est\u00e1 en el cat\u00e1logo interno. Agr\u00e9galo en dev.e4studio.e4core.service.catalog.InternalPluginCatalog para habilitar /e4core download " + managedPlugin.getName());
        }
    }

    private void registerCommands() {
        PluginCommand command = this.getCommand("e4core");
        if (command == null) {
            this.getLogger().warning("[e4Core] Command e4core is not defined in plugin.yml.");
            return;
        }
        command.setExecutor((CommandExecutor)new E4CoreCommand(this));
        command.setTabCompleter((TabCompleter)new E4CoreCommandCompleter(this));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PluginLifecycleListener((Plugin)this, this.databaseManager, this.analyticsManager), (Plugin)this);
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public AnalyticsManager getAnalyticsManager() {
        return this.analyticsManager;
    }

    public PluginCatalogService getCatalogService() {
        return this.catalogService;
    }

    public PluginInstallerService getInstallerService() {
        return this.installerService;
    }

    public E4PluginManager getPluginManagerService() {
        return this.pluginManagerService;
    }
}

